import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a figure and axis
fig, ax = plt.subplots(figsize=(8, 4))

# Define colors
clear_color = 'green'
text_color = 'black'

# Define positions and sizes
curb_width = 1
curb_height = 2
car_radius = 0.3
curb_gap = 1.5

# Define goal state
curbs = [
    {'id': 'curb_0', 'cars': [('car0', clear_color)], 'x': 0},
    {'id': 'curb_1', 'cars': [('car1', clear_color)], 'x': 1},
    {'id': 'curb_2', 'cars': [('car2', clear_color)], 'x': 2},
    {'id': 'curb_3', 'cars': [('car3', clear_color)], 'x': 3},
]

# Draw curbs and cars
for curb in curbs:
    x_pos = curb['x'] * curb_gap
    # Draw curb
    ax.add_patch(patches.Rectangle((x_pos, 0), curb_width, curb_height, edgecolor='black', facecolor='lightgray'))
    ax.text(x_pos + curb_width / 2, curb_height + 0.1, curb['id'], ha='center', va='bottom', fontsize=8, color=text_color)

    # Draw cars
    for i, (car_id, status_color) in enumerate(curb['cars']):
        car_y = curb_height - (i + 1) * (car_radius * 2 + 0.1)
        ax.add_patch(patches.Circle((x_pos + curb_width / 2, car_y), car_radius, edgecolor='black', facecolor=status_color))
        ax.text(x_pos + curb_width / 2, car_y, f"{car_id}\nClear", ha='center', va='center', fontsize=8, color=text_color)

# Create a legend
legend_elements = [
    patches.Patch(facecolor=clear_color, edgecolor='black', label='Clear')
]
ax.legend(handles=legend_elements, loc='upper right', bbox_to_anchor=(1.15, 1))

# Set limits and hide axes
ax.set_xlim(-0.5, len(curbs) * curb_gap - 0.5)
ax.set_ylim(-0.5, curb_height + 0.5)
ax.axis('off')

# Save the figure
plt.savefig('<PATH_REMOVED>', bbox_inches='tight')
plt.show()